function estIntegral = integralTrap(f, a, b)
% Numerical integration using the Trapezoid rule.
%
% INPUTS:
%       f - The function handle.
%       a - Lower limit.
%       b - Upper limit.
%
% OUTPUT:
%       Int - The numerical estimate of the integral.

h = b - a;
estIntegral = (h/2)*(f(a) + f(b));

end

